<?php
/**
 * Verifie si le panier existe, le créé sinon
 * @return booleen
 */
function creationPanier(){
   if (!isset($_SESSION['panier'])){
      $_SESSION['panier']=array();
      $_SESSION['panier']['ref'] = array();
      $_SESSION['panier']['name'] = array();
      $_SESSION['panier']['quantite'] = array();
      $_SESSION['panier']['price'] = array();
      $_SESSION['panier']['available'] = array();
      $_SESSION['panier']['alinea'] = array();
      $_SESSION['panier']['verrou'] = false;
   }
   return true;
}
$json =array('error'=>true);

/**
 * Ajoute un article dans le panier
 * @param string $ref
 * @param string $name
 * @param string $alinea
 * @param float $quantite
 * @param float $price
 * @param float $available
 * @return void
 */
function ajouterArticle($ref,$name,$quantite,$price,$available,$alinea){

   //Si le panier existe
   if (creationPanier() && !isVerrouille())
   {
      //Si le produit existe déjà on ajoute seulement la quantité
      $positionProduit = array_search($name,  $_SESSION['panier']['name']);

      if ($positionProduit !== false)
      {
         modifierQTeArticle($name,$quantite);
      }
      else
      {
         //Sinon on ajoute le produit
         array_push( $_SESSION['panier']['ref'],$ref);
         array_push( $_SESSION['panier']['name'],$name);
         array_push( $_SESSION['panier']['quantite'],$quantite);
         array_push( $_SESSION['panier']['price'],$price);
         array_push( $_SESSION['panier']['available'],$available);
         array_push( $_SESSION['panier']['alinea'],$alinea);
      }
       /*echo "<script type='text/javascript'>";
       echo "alert('votre choix a été effectuer avec succès');";
       echo "window.location.href='vente.php';";
       echo "</script>";*/
   }
   
}


/**
 * Modifie la quantité d'un article
 * @param string $ref
 * @param $name
 * @param $quantite
 * @param $available
 * @param $alinea
 * @return void
 */
function modifierQTeArticle($name,$quantite){
   //Si le panier éxiste
   if (creationPanier() && !isVerrouille())
   {
      //Si la quantité est positive on modifie sinon on supprime l'article
      if ($quantite > 0)
      {
         //Recharche du produit dans le panier
         $positionProduit = array_search($name,  $_SESSION['panier']['name']);

         if ($positionProduit !== false)
         {
            $_SESSION['panier']['quantite'][$positionProduit] = $quantite;
         }
      }
      else
      supprimerArticle($name);
   }
   else
   echo "Un problème est survenu veuillez contacter l'administrateur du site.";
}

/**
 * Supprime un article du panier
 * @param $name
 * @return unknown_type
 */
function supprimerArticle($name){
   //Si le panier existe
   if (creationPanier() && !isVerrouille())
   {
      //Nous allons passer par un panier temporaire
      $tmp=array();
      $tmp['ref'] = array();
      $tmp['name'] = array();
      $tmp['quantite'] = array();
      $tmp['price'] = array();
      $tmp['available'] = array();
      $tmp['alinea'] = array();
      $tmp['verrou'] = $_SESSION['panier']['verrou'];

      for($i = 0; $i < count($_SESSION['panier']['name']); $i++)
      {
         if ($_SESSION['panier']['name'][$i] !== $name)
         {
            array_push( $tmp['ref'],$_SESSION['panier']['ref'][$i]);
            array_push( $tmp['name'],$_SESSION['panier']['name'][$i]);
            array_push( $tmp['quantite'],$_SESSION['panier']['quantite'][$i]);
            array_push( $tmp['price'],$_SESSION['panier']['price'][$i]);
            array_push( $tmp['available'],$_SESSION['panier']['available'][$i]);
            array_push( $tmp['alinea'],$_SESSION['panier']['alinea'][$i]);
         }

      }
      //On remplace le panier en session par notre panier temporaire à jour
      $_SESSION['panier'] =  $tmp;
      //On efface notre panier temporaire
      unset($tmp);
   }
   else
   echo "Un problème est survenu veuillez contacter l'administrateur du site.";
}


/**
 * Montant total du panier
 * @return float
 */
function MontantGlobal(){
   $total=0;
   for($i = 0; $i < count($_SESSION['panier']['name']); $i++)
   {
      $total += $_SESSION['panier']['quantite'][$i] * $_SESSION['panier']['price'][$i];
   }
   return $total;
}


/**
 * Fonction de suppression du panier
 * @return void
 */
function supprimePanier(){
   unset($_SESSION['panier']);
}

/**
 * Permet de savoir si le panier est verrouillé
 * @return booleen
 */
function isVerrouille(){
   if (isset($_SESSION['panier']) && $_SESSION['panier']['verrou'])
   return true;
   else
   return false;
}

/**
 * Compte le nombre d'articles différents dans le panier
 * @return float
 */
function compterArticles()
{
   if (isset($_SESSION['panier']))
   return count($_SESSION['panier']['name']);
   else
   return 0;

}

?>